<?php

namespace Visiosoft\PaymentModule\Listener;

use Visiosoft\PaymentModule\Payment\Contract\PaymentRepositoryInterface;
use Visiosoft\PaypalWebhooksExtension\Events\OrderCancelled;

class PaymentCancelledListener
{
    public function handle(OrderCancelled $event) {
        if(!$paymentId = $event->resource->payments->captures->invoice_id) {
            throw new \Exception(trans('visiosoft.extension.paypal_webhooks::message.invoice_id_not_found'));
        }
        //todo log if paymentId not found *****************important**************
        $paymentRepository = app(PaymentRepositoryInterface::class);
        if (!$payment = $paymentRepository->find($paymentId)) {
            throw new \Exception(trans('visiosoft.extension.paypal_webhooks::message.payment_not_found'));
        }
        $payment->update(['status_id' => 4]);
    }
}