<?php namespace Visiosoft\PaymentModule\Category;

use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Visiosoft\PaymentModule\Category\Contract\CategoryRepositoryInterface;

class CategorySeeder extends Seeder
{

    /**
     * Run the seeder.
     */
    public function run(CategoryRepositoryInterface $categoryRepository)
    {
        if (!$categoryRepository->findBy('slug', 'charging')) {
            $categoryRepository->create([
                'en' => [
                    'name' => 'Charging'
                ],
                'slug' => 'charging'
            ]);
        }
        if (!$categoryRepository->findBy('slug', 'parking')) {
            $categoryRepository->create([
                'en' => [
                    'name' => 'Parking'
                ],
                'slug' => 'parking'
            ]);
        }
    }
}
