<?php namespace Visiosoft\PaymentModule\Payment\SettingsHandler;

use Anomaly\SelectFieldType\SelectFieldType;
use Anomaly\Streams\Platform\Addon\Extension\ExtensionCollection;
use Anomaly\Streams\Platform\Addon\Module\Module;
use Anomaly\Streams\Platform\Addon\Module\ModuleCollection;

class InvoiceHandler
{
    public function handle(SelectFieldType $fieldType, ModuleCollection $moduleCollection)
    {
        $invoice_provider = $moduleCollection
            ->where('provide', 'invoice_provider')
            ->pluck('name', 'namespace')
            ->all();

        $fieldType->setOptions($invoice_provider);
    }
}
