<?php namespace Visiosoft\PaymentModule\Job;

use Anomaly\UsersModule\User\UserRepository;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Visiosoft\PaymentModule\Helper\InvoiceHelper;
use Visiosoft\InvoiceModule\Job\CreateUserInvoiceJob;

class AutoInvoiceJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    protected $userId;
    protected $payment;
    protected $paymentStatus;
    protected $userData;

    public function __construct($userId, $payment, $paymentStatus, $userData)
    {
        $this->userId = $userId;
        $this->payment = $payment;
        $this->paymentStatus = $paymentStatus;
        $this->userData = $userData;
    }

    public function handle()
    {
        $details = [];
        $payment = $this->payment;
        $invoiceHelper = app(InvoiceHelper::class);
        $user = $invoiceHelper->getUser($payment['user_id']);
        $getVehicleSessions = $invoiceHelper->getVehicleSessions($payment);
        $vehicles = $getVehicleSessions['vehicles'];
        $vehicleSessions = $getVehicleSessions['sessions'];
        $plateImages = $getVehicleSessions['plate_images'];
        $userData = $this->userData;
        if (!empty($vehicleSessions)) {
            foreach ($vehicleSessions as $vehicleId => $sessions) {
                $plate = $vehicles[$vehicleId];
                $vehicle = $invoiceHelper->getVehicle($vehicleId, $plate);
                $images = [];
                if (!empty($plateImages[$vehicleId])) {
                    $images = $plateImages[$vehicleId];
                }
                $details[$vehicleId] = $invoiceHelper->getInvoiceDetails($user, $vehicle, $sessions, $images);
            }
            $mainCreditorUserId = setting_value('visiosoft.module.invoice::main_creditor');
            $creditor = $invoiceHelper->getCreditor($mainCreditorUserId, 'business');
            $creditorUser = $invoiceHelper->getUser($mainCreditorUserId);
            if (!empty($details)) {
                foreach ($details as $detail) {
                    if (empty($userData)) {
                        $debtor = $invoiceHelper->getDebtor($detail['user']['id'], 'personal', $creditor->external_id);
                    } else {
                        $location = $invoiceHelper->getInvoiceLocation($payment);
                        $name = trans('visiosoft.module.payment::field.unregistered_user_invoice.name');
                        if (empty($userData['name'])) {
                            $userRepository = app(UserRepository::class);
                            $user = $userRepository->find($this->userId);
                            if ($user) {
                                $name = $user->name();
                            }
                        }
                        $debtor = $invoiceHelper->getOrCreateDebtor(
                            $userData['email'],
                            $creditor->external_id,
                            'personal',
                            $location,
                            $name
                        );
                    }
                    $debtorUser = $invoiceHelper->getUser($detail['user']['id']);
                    $detail['creditor_external_id'] = $creditor->external_id;
                    $detail['debtor_external_id'] = $debtor->external_id;
                    $detail['creditor_id'] = $creditor->id;
                    $detail['debtor_id'] = $debtor->id;
                    $detail['debtor_phone'] = $debtorUser['phone'];
                    $detail['debtor_email'] = $debtorUser['email'];
                    $detail['creditor_phone'] = $creditorUser['phone'];
                    $detail['creditor_email'] = $creditorUser['email'];
                    $detail['payment_id'] = $payment['id'];
                    $records = $invoiceHelper->generateInvoiceRecords($detail);
                    $detail['invoice_records'] = $records;
                    CreateUserInvoiceJob::dispatch($detail, $this->paymentStatus);
                }
            }
        }
    }
}
