<?php namespace Visiosoft\PaymentModule\Payment\Table;

use Anomaly\Streams\Platform\Ui\Table\TableBuilder;
use Illuminate\Database\Eloquent\Builder;
use Visiosoft\PaymentModule\Payment\PaymentWithoutAttrModel;
use Visiosoft\PaymentModule\Payment\Table\Filter\UserFilter;

class PaymentTableBuilder extends TableBuilder
{

    /**
     * The table views.
     *
     * @var array|string
     */
    protected $views = [];

    /**
     * The table filters.
     *
     * @var array|string
     */
    protected $filters = [];



    protected $model = PaymentWithoutAttrModel::class;

    /**
     * The table columns.
     *
     * @var array|string
     */
    protected $columns = [];

    /**
     * The table buttons.
     *
     * @var array|string
     */
    protected $buttons = [];

    /**
     * The table actions.
     *
     * @var array|string
     */
    protected $actions = ['delete'];

    /**
     * The table options.
     *
     * @var array
     */
    protected $options = [];

    /**
     * The table assets.
     *
     * @var array
     */
    protected $assets = [
        'scripts.js' => [
            'visiosoft.module.payment::js/filter-user.js',
        ]
    ];
    public function onQuerying(Builder $query)
    {
        $query->orderBy("id", "desc");
    }



}
