<?php

namespace Visiosoft\PaymentModule\Listener;

use Visiosoft\PaymentModule\Payment\Contract\PaymentRepositoryInterface;
use Visiosoft\PaymentModule\Status\Contract\StatusRepositoryInterface;
use Visiosoft\SwishModule\Event\PaymentResultEvent;

class SwishPaymentResultListener
{

    public function handle(PaymentResultEvent $event)
    {
        $values = $event->values;
        $paymentRepository = app(PaymentRepositoryInterface::class);
        $paymentStatusRepository = app(StatusRepositoryInterface::class);

        if (!$payment = $paymentRepository->newQuery()->where('payment_intent_id', $values['payment_intent_id'])->first()) {
            throw new \Exception(trans('visiosoft.module.connect::message.not_found', ['name' => 'Payment']));
        }

        if ($values['success']) {
            $status = $paymentStatusRepository->findBySlug('paid');
            $payment->update(['status_id' => $status->getId()]);
        } else {
            $status = $paymentStatusRepository->findBySlug('failed');
            $payment->update(['status_id' => $status->getId()]);
        }

    }
}