<?php namespace Visiosoft\PaymentModule;

use Anomaly\Streams\Platform\Addon\Module\Module;
use Anomaly\Streams\Platform\Image\Command\MakeImageInstance;
use Anomaly\Streams\Platform\Ui\Table\Component\View\View;
use Barryvdh\DomPDF\Facade\Pdf;
use Illuminate\Support\Facades\Storage;
use Visiosoft\ParkingModule\Park\Contract\PricingCostCalculateHelperInterface;
use Visiosoft\ParkingModule\ParkingSession\Contract\ParkingSessionRepositoryInterface;
use Visiosoft\PaymentModule\Payment\PaymentModel;

class PaymentModule extends Module
{

    /**
     * The navigation display flag.
     *
     * @var bool
     */
    protected $navigation = true;

    /**
     * The addon icon.
     *
     * @var string
     */
    protected $icon = 'fa fa-puzzle-piece';

    /**
     * The module sections.
     *
     * @var array
     */
    protected $sections = [
        'category' => [
            'buttons' => [
                'new_category',
            ],
        ],
        'payment_methods' => [
            'buttons' => [
                'new_payment_method',
            ],
        ],
        'payment',
        'status'
    ];

    public function createInvoice(PaymentModel $payment, $customer)
    {
        $pricingCostCalculateHelper = app(PricingCostCalculateHelperInterface::class);
        $parkingSessionRepository = app(ParkingSessionRepositoryInterface::class);
        $startedAt = strtotime($payment->park_session->started_at);
        $endedAt = strtotime($payment->park_session->ended_at);
        $prices = $payment->park_session->park->prices;
        $paymentAmount = $payment->amount;
        $duration = $endedAt - $startedAt;
        $cost = $pricingCostCalculateHelper->calculate($prices, $duration);
        $details = $parkingSessionRepository->getDetail($paymentAmount, $cost, $duration);
        $logoFile = dispatch_now(new MakeImageInstance('theme::images/drifter-logo-black.png', 'img'));
        $logo_url = $logoFile->url();
        $logo = base64_encode(file_get_contents($logo_url));
        $base64Image = 'data:image/png;base64,' . $logo;
        $html = View::make('visiosoft.module.payment::invoice', [
            'logo' => $base64Image,
            'payment' => $payment,
            'details' => $details,
            'started_at' => date('Y-m-d H:i', $startedAt),
            'ended_at' => date('Y-m-d H:i', $endedAt),
            'customer_name' => $customer['customer_name'],
            'customer_email' => $customer['customer_email'],
            'payment_status' => $payment->status->name,
            'source_of_collection' => ''
        ])->render();
        $pdf = Pdf::loadHTML($html)->output();
        $fileName = 'invoices/park_session_' . $payment->id . '_' . date('Y-m-d_H-i') . '.pdf';
        $file = Storage::disk('local')->put($fileName, $pdf);
        $payment->update(['invoice_file' => $file->id]);
        return config('app.url') . '/files/' . $file->path();
    }

    public function retrieveInvocieUrl(PaymentModel $payment)
    {
        return config('app.url') . '/files/' . $payment->invoiceFile()->first()->path();
    }
}
