<?php namespace Visiosoft\PaymentModule\Payment\Table;

use Anomaly\Streams\Platform\Entry\Contract\EntryInterface;

class PaymentTableButtons
{
    public function handle(PaymentTableBuilder $builder)
    {

        $buttons = [
            'receive_payment' => [
                'class' => function (EntryInterface $entry) {
                    if (!preg_match("/(1|3|4)/i", $entry->status_id)) {
                        return 'hidden';
                    } else if (!$entry->getPaymentMethod()) {
                        return 'disabled';
                    }
                }
            ],
            'edit',
        ];

        $builder->setButtons($buttons);

        return $buttons;
    }

}
