<?php namespace Visiosoft\PaymentModule\PaymentMethod\Table;

use Anomaly\Streams\Platform\Entry\Contract\EntryInterface;
use Anomaly\UsersModule\User\Contract\UserRepositoryInterface;

class PaymentMethodTableColumns
{

    public function handle(PaymentMethodTableBuilder $builder)
    {
        $columns = [
            'id' => [
                'wrapper' => '{entry.id}'
            ],
            'user' => [
                'wrapper' => '{value.name}',
                'value' => [
                    'name' => function (EntryInterface $entry, UserRepositoryInterface $userRepository) {
                        $user = $userRepository->findWithTrashed($entry->owner_id);

                        if ($user) {
                            $text = "<small class='text-info'>(" . $user->id . ") </small> " . $user->first_name . ' ' . $user->last_name . '&nbsp;&nbsp;&nbsp;<i class="fa fa-phone"> ' . $user->phone . '</i>';

                            if ($user->deleted_at) {
                                return "<span class='text-danger'>" . $text . "</span>";
                            }

                            return $text;
                        }

                        return "-";
                    }
                ]
            ],
            'service',
            'last_4_digits' => [
                'wrapper' => '{value.digits}',
                'value' => [
                    'digits' => function (EntryInterface $entry) {
                        return $entry->card['last4'];
                    }
                ]
            ]
        ];
        $builder->setColumns($columns);
    }
}
