<?php namespace Visiosoft\PaymentModule\Payment;

use Carbon\Carbon;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Support\Facades\Auth;
use Visiosoft\ConnectModule\Command\CheckRequiredParams;
use Visiosoft\PaymentModule\Category\Contract\CategoryRepositoryInterface;
use Visiosoft\PaymentModule\Status\Contract\StatusRepositoryInterface;
use Visiosoft\PaymentStripeExtension\PaymentStripeExtension;

class PaymentApiCollection extends PaymentRepository
{
    use DispatchesJobs;


    public function createCard(array $params)
    {
        $create_card = PaymentStripeExtension::createCard($params);
        return $create_card;
    }

    public function cards($params)
    {
        $cards = PaymentStripeExtension::cards($params);
        return $cards;
    }

    public function createDraftPayment(array $params)
    {
        $paymentData = [
            'user_id' => $params['user_id'],
            'amount' => $params['amount'],
            'usage' => $params['usage'],
            'status' => 1,
            'category_id' => $params['category_id'],
            'currency' => "SEK"
        ];
        if (!empty($params['transaction_id'])) {
            $paymentData['transaction_id'] = $params['transaction_id'];
        }
        if (!empty($params['park_session_id'])) {
            $paymentData['park_session_id'] = $params['park_session_id'];
        }
        $create = $this->newQuery()->create($paymentData);

        if (!$create) {
            throw new \Exception(trans('visiosoft.module.payment::message.transaction_create_failed'), 400);
        }
        return $create;
    }


    public function createPayment(array $params)
    {

        $payment = $this->newQuery()->where('transaction_id', $params['transaction_id'])->first();

        $payment_params = ['currency' => "SEK", 'amount' => $payment['amount'], 'method_id' => $params['method_id']];

        $create_payment = PaymentStripeExtension::createPaymentIntent($payment_params);
        $payment->update(['payment_intent_id' => $create_payment['id']]);
        return $this->confirmPayment(['payment_id' => $create_payment['id']]);
    }

    public function confirmPayment(array $params)
    {
        $confirm_payment = PaymentStripeExtension::confirmPaymentIntent($params);
        $payment = $this->newQuery()->where('payment_intent_id', $params['payment_id'])->first();
        if ($confirm_payment['status'] == "succeeded") {
            $payment->update(['status_id' => 2]);
        } else throw new \Exception("Payment Failed", 404);
        return $payment;
    }

    public function list(array $params)
    {
        $userId = Auth::id();
        $payments = $this->newQuery()
            ->where('user_id', $userId)
            ->orderBy('created_at', 'DESC');
        if (!empty($params['category_id'])) {
            $payments = $payments->where('category_id', $params['category_id']);
        }
        if (!empty($params['status_id'])) {
            $payments = $payments->where('status_od', $params['status_id']);
        }
        if (!empty($params['start_date'])) {
            $payments = $payments->where('created_at', '>=', $params['start_date']);
        }
        if (!empty($params['end_date'])) {
            $payments = $payments->where('created_at', '<=', $params['end_date']);
        }
        return $payments->get();
    }

    public function references()
    {
        $categoryRepository = app(CategoryRepositoryInterface::class);
        $statusRepository = app(StatusRepositoryInterface::class);
        return collect([
            'statuses' => $statusRepository->newQuery()->get(),
            'category' => $categoryRepository->newQuery()->get()
        ]);
    }
}
