<?php

namespace Visiosoft\PaymentModule\Event;

use Visiosoft\PaymentModule\Payment\PaymentModel;

class UnpaidPaymentReminderEvent
{

    private PaymentModel $payment;

    public function __construct(PaymentModel $payment)
    {
        $this->payment = $payment;
    }

    public function getPaymentId()
    {
        return $this->payment->id;
    }

    public function getPaymentDate()
    {
        return $this->payment->created_at;
    }

    public function getPaymentAmount()
    {
        return $this->payment->payment_amount;
    }

    public function getPaymentCurrency()
    {
        return $this->payment->currency;
    }

    public function getUser()
    {
        return $this->payment->user;
    }

    public function getPaymentLastTry()
    {
        return $this->payment->last_try;
    }

    public function setPaymentLastNotify()
    {
        $this->payment->setAttribute('last_notify', date('Y-m-d H:i:s'));
        $this->payment->save();
    }
}