<?php namespace Visiosoft\PaymentModule\Payment\Table;

use Anomaly\Streams\Platform\Entry\Contract\EntryInterface;
use Anomaly\UsersModule\User\Contract\UserRepositoryInterface;
use Visiosoft\PaymentModule\Helper\CommonHelper;
use Visiosoft\PaymentModule\PaymentMethod\Contract\PaymentMethodRepositoryInterface;
use function Clue\StreamFilter\fun;

class PaymentTableColumns
{
    protected $helper;
    protected $infoNotAvailable;
    protected $userRepository;

    public function __construct(CommonHelper $helper)
    {
        $this->helper = $helper;
        $this->infoNotAvailable = trans('visiosoft.module.payment::message.info_not_available');
        $this->userRepository = app(UserRepositoryInterface::class);
    }

    public function handle(PaymentTableBuilder $builder)
    {

        $columns = [
            'id' => ['wrapper' => '{entry.id}'],
            'user' => [
                'wrapper' => '{value.name}',
                'value' => [
                    'name' => function (EntryInterface $entry) {
                        return $this->getUserColumn($entry);
                    }
                ]
            ],
            'plate',
            'payment_amount' => [
                'wrapper' => '{value.payment_amount}',
                'value' => [
                    'payment_amount' => function (EntryInterface $entry) {
                        return $entry->payment_amount . " " . $entry->currency;
                    }
                ]
            ],
            'transaction',
            'payment_method' => [
                'wrapper' => '{value.card}',
                'value' => [
                    'card' => function (EntryInterface $entry) {
                        return $this->getPaymentMethodColumn($entry);
                    }
                ]
            ],
            'status',
            'service_message' => [
                'wrapper' => '{value.service_message}',
                'value' => [
                    'service_message' => function (EntryInterface $entry) {
                        $service_message = $entry->service_message;
                        if (!empty($entry->error_code)) {
                            $service_message .= " - " . $entry->error_code;
                        }
                        return $service_message;
                    }
                ]
            ]
        ];

        $builder->setColumns($columns);
    }

    protected function getUserColumn(EntryInterface $entry)
    {
        $user = $this->userRepository->findByIdWithThrashed($entry->user_id);
        if ($user) {
            $userInfo = $user->first_name . ' ' . $user->last_name . ' ' . $user->email . ' ' . $user->phone;
            if (empty($userInfo)) {
                $userInfo = $this->infoNotAvailable;
            }

            return $userInfo;
        } else {
            trans("visiosoft.module.payment::field.unregistered_user");
        }
    }

    protected function getPaymentMethodColumn(EntryInterface $entry)
    {
        $user = $this->userRepository->findByIdWithThrashed($entry->user_id);
        $paymentMethodRepository = app(PaymentMethodRepositoryInterface::class);
        $paymentMethod = $paymentMethodRepository->getDefaultCardByOwner($user->id);
        $noCardMessage = trans('visiosoft.module.payment::message.user_has_no_card');
        if ($paymentMethod) {
            $card = $this->helper->getDataInPaymentMethodJson($paymentMethod->card, 'last4');
            return !empty($card) ? $card : $this->infoNotAvailable;
        } else {
            return $noCardMessage;
        }
    }
}