<?php namespace Visiosoft\PaymentModule\Status;

use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Visiosoft\PaymentModule\Status\Contract\StatusRepositoryInterface;

class StatusSeeder extends Seeder
{

    /**
     * Run the seeder.
     */
    public function run(StatusRepositoryInterface $statusRepository)
    {
        if (!$statusRepository->findBy('slug', 'pending')) {
            $statusRepository->create([
                'en' => [
                    'name' => 'pending'
                ],
                'slug' => 'pending'
            ]);
        }
        if (!$statusRepository->findBy('slug', 'paid')) {
            $statusRepository->create([
                'en' => [
                    'name' => 'paid'
                ],
                'slug' => 'paid'
            ]);
        }
    }
}
