<?php namespace Visiosoft\PaymentModule\Payment;

use Carbon\Carbon;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Support\Facades\Auth;
use Visiosoft\ConnectModule\Command\CheckRequiredParams;
use Visiosoft\PaymentStripeExtension\PaymentStripeExtension;
class PaymentApiCollection extends PaymentRepository
{
    use DispatchesJobs;


    public function createCard(array $params)
    {
        $create_card = PaymentStripeExtension::createCard($params);
        return $create_card;
    }

    public function cards($params)
    {
      $cards = PaymentStripeExtension::cards($params);
      return $cards;
    }

    public function createPayment(array $params)
    {
        $create_payment = PaymentStripeExtension::createPaymentIntent($params);

        $payment = $this->newQuery()->create([
            'user_id' => Auth::id(),
            'transaction_id' => $params['transaction_id'],
            'payment_intent_id' => $create_payment['id'],
            'amount'=>$params['amount'],
            'payment_method'=>$params['method_id'],
            'status'=>"pending"
        ]);

        return $payment;
    }

    public function confirmPayment(array $params)
    {
        $confirm_payment = PaymentStripeExtension::confirmPaymentIntent($params);

        $payment = $this->newQuery()->where('payment_intent_id', $params['payment_id'])->first();

        if ($confirm_payment['status']=="succeeded")
        {
            $payment->update(['status'=>"paid"]);
        }else throw new \Exception("Payment Failed", 404);


        return $payment;
    }

}
