<?php namespace Visiosoft\PaymentModule\Payment;

use Visiosoft\ChargingModule\Transaction\TransactionWithoutAttributeModel;
use Visiosoft\StationModule\Station\StationWithoutAttributeModel;
use Visiosoft\VehicleModule\Vehicle\VehicleWithoutAttributeModel;

class PaymentWithoutAttrModel extends PaymentModel
{
    protected $appends = ['fees', 'name'];

    public function vehicle()
    {
        return $this->belongsTo(VehicleWithoutAttributeModel::class, 'vehicle_id');
    }

    public function chargingTransaction()
    {
        return $this->belongsTo(TransactionWithoutAttributeModel::class, 'transaction_id');
    }

    public function station()
    {
        return $this->belongsTo(StationWithoutAttributeModel::class, 'station_id');
    }
}
