<?php namespace Visiosoft\PaymentModule;

use Anomaly\Streams\Platform\Addon\Module\Module;
use Anomaly\Streams\Platform\Image\Command\MakeImageInstance;
use Anomaly\Streams\Platform\Ui\Table\Component\View\View;
use Barryvdh\DomPDF\Facade\Pdf;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;
use Visiosoft\ChargingModule\Transaction\Contract\TransactionRepositoryInterface;
use Visiosoft\ParkingModule\Park\Contract\PricingCostCalculateHelperInterface;
use Visiosoft\ParkingModule\ParkingSession\Contract\ParkingSessionRepositoryInterface;
use Visiosoft\PaymentModule\Payment\Contract\PaymentRepositoryInterface;
use Visiosoft\PaymentModule\Payment\PaymentModel;

class PaymentModule extends Module
{

    protected $root_menu = 'Drifter';

    protected $navigation = true;

    protected $icon = 'fa fa-puzzle-piece';

    protected $sections = [
        'category' => [
            'buttons' => [
                'new_category',
            ],
        ],
        'payment_methods' => [
            'buttons' => [
                'new_payment_method',
            ],
        ],
        'payment',
        'status'
    ];

    public function createInvoice(PaymentModel $payment, $customer,$type="park")
    {
        $view = app('Illuminate\Contracts\View\Factory');
        $paymentRepo = app(PaymentRepositoryInterface::class);
        $pricingCostCalculateHelper = app(PricingCostCalculateHelperInterface::class);
        if ($type=="park")
        {
            $startedAt = strtotime($payment->park_session->started_at);
            $endedAt = strtotime($payment->park_session->ended_at);
            if (!$payment->park_session->ended_at) {
                $endedAt = time();
            }
        }else if ($type=="transaction"){
            $startedAt = strtotime($payment->transaction->started_at);
            $endedAt = strtotime($payment->transaction->ended_at);
            if (!$payment->transaction->ended_at) {
                $endedAt = time();
            }
        }

        $paymentAmount = $payment->amount;
        $duration = $endedAt - $startedAt;
        if ($type=="park")
        {
            $prices = $payment->park_session->park->prices;
            $parkingSessionRepository = app(ParkingSessionRepositoryInterface::class);
            $cost = $pricingCostCalculateHelper->calculate($prices, $duration);
            $details = $parkingSessionRepository->getDetail($paymentAmount, $cost, $duration);
        }else if ($type=="transaction"){
            $transactionRepository = app(TransactionRepositoryInterface::class);
            $details = $transactionRepository->getDetail($paymentAmount,$duration);
        }
        $html = $view->make('visiosoft.module.payment::invoice', [
            'logo' => '',
            'type'=>$type,
            'payment' => $payment,
            'details' => $details,
            'started_at' => date('Y-m-d H:i', $startedAt),
            'ended_at' => date('Y-m-d H:i', $endedAt),
            'customer_name' => $customer['customer_name'],
            'customer_email' => $customer['customer_email'],
            'payment_status' => $payment->status->name,
            'source_of_collection' => ''
        ])->render();
        $pdf = Pdf::loadHTML($html)->output();
        $fileName = 'invoices/'.$type.'_session_' . $payment->id . '_' . date('Y-m-d_H-i') . '.pdf';
        $file = Storage::disk('local')->put($fileName, $pdf);
        $paymnet2 = $paymentRepo->find($payment->id);
        $paymnet2->update(['invoice_file_id' => $file->id]);
        return config('app.url') . '/files/' . $file->path();
    }

    public function retrieveInvocieUrl(PaymentModel $payment)
    {
        return config('app.url') . '/files/' . $payment->invoiceFile()->first()->path();
    }
}
