<?php namespace Visiosoft\PaymentModule;

use Anomaly\Streams\Platform\Addon\Module\Module;
use Anomaly\Streams\Platform\Image\Command\MakeImageInstance;
use Anomaly\Streams\Platform\Ui\Table\Component\View\View;
use Barryvdh\DomPDF\Facade\Pdf;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;
use Visiosoft\ParkingModule\Park\Contract\PricingCostCalculateHelperInterface;
use Visiosoft\ParkingModule\ParkingSession\Contract\ParkingSessionRepositoryInterface;
use Visiosoft\PaymentModule\Payment\Contract\PaymentRepositoryInterface;
use Visiosoft\PaymentModule\Payment\PaymentModel;

class PaymentModule extends Module
{

    /**
     * The navigation display flag.
     *
     * @var bool
     */
    protected $navigation = true;

    /**
     * The addon icon.
     *
     * @var string
     */
    protected $icon = 'fa fa-puzzle-piece';

    /**
     * The module sections.
     *
     * @var array
     */
    protected $sections = [
        'category' => [
            'buttons' => [
                'new_category',
            ],
        ],
        'payment_methods' => [
            'buttons' => [
                'new_payment_method',
            ],
        ],
        'payment',
        'status'
    ];

    public function createInvoice(PaymentModel $payment, $customer)
    {
        $view = app('Illuminate\Contracts\View\Factory');
        $paymentRepo = app(PaymentRepositoryInterface::class);
        $pricingCostCalculateHelper = app(PricingCostCalculateHelperInterface::class);
        $parkingSessionRepository = app(ParkingSessionRepositoryInterface::class);
        $startedAt = strtotime($payment->park_session->started_at);
        $endedAt = strtotime($payment->park_session->ended_at);
        if (!$payment->park_session->ended_at) {
            $endedAt = time();
        }
        $prices = $payment->park_session->park->prices;
        $paymentAmount = $payment->amount;
        $duration = $endedAt - $startedAt;
        $cost = $pricingCostCalculateHelper->calculate($prices, $duration);
        $details = $parkingSessionRepository->getDetail($paymentAmount, $cost, $duration);
//        $logoFile = dispatch_now(new MakeImageInstance('theme::images/drifter-logo-black.png', 'img'));
//        $logo_url = $logoFile->url();
//        $logo = base64_encode(file_get_contents($logo_url));
//        $base64Image = 'data:image/png;base64,' . $logo;
        $base64Image = 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAXcAAABdCAYAAABegCYaAAAACXBIWXMAACE4AAAhOAFFljFgAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAABJ5SURBVHgB7Z1bchTL0cezqnsUJ2zCn74VnPYKGHThO+EXRitA+EOc88ZoBYgVMFoB0goQb44DGLECDS8OAo3EeAUMK7AcfsHMdKUze3qwpDOSunq6+pq/CNCt59ad9e+srKxMBTnQbv8StLzwiL4NEj0AYQQKzug7/jdCxC9ocKhBj46Hr4YgCIIgXIsCx7Tbm8str/UJkgp7MvqgcGgm+D6EsD8cHp6BIAiC8B3n4r6ystX1FLwAt/TJ2385NmMW+hEIgiA0HA31oEO3qRc0Q/i8vrp1tE43FBAEQWgwdfHc5zGiGP3ev8N/vxNvXmg6HB71td9VSt3mH2mmu3z5GATcH5y+3gOhFvhQXwIDZs/3Wj3y5g/H4XhXRL4arNHsS/FsLCGocGMweN2HErK28rBHgvos6fGIuEsC24OMWGs/7Cgvev3OhT/Mc+vmCP61z12j61RH6hKWuRIyPjbYLoVsju6uPEo8yAShynCGGocoSdg5S60DQuOovbifIyDPgb34zxKTF+rM+urPT3wv5Ay1DgiNpUniPiPgxVcS+RcUhwxAEGrEWjQ7NXvxjFVoME0U9xlRqGZ19f83QRBqAAu7otkpCAI0W9yZQIN+K7F4oepwqFGEXThP08U9gmPxd1cfveV0MRCEisGLpxRqFAdFuICIewwCbnKZBInDC1XD1+YxZFveQ6gBIu4XCTgOLwIvVAkKx3RBEC4h4v5bROCFysCblEC8dmEOIu7zEYEXqoFOmcuOXE7b7IcI2wbMA9496hv/AITaUOfyA4syE/gNKVsgpOWWmex9/QEOkh7/w1ewK189rRVjidn/vQl7fSmVXWuci7vW+COg8/pkrpgJ/B2pGS+kIRZQl7ZjmeGFw+OTNzsg1B6nYRneBq1Q9aDasMC/BUEoIYorPNqAah+ERuBM3GfboKEedGSjk1BSrDz3sRkfgtAInIRlrtsGjTQthBumqeTt86aMAEoEb3RaW3v4XkqWXuQnWnT+Bq2O5+NthTqg6xt8Lx0b98FVoM4Mmr9zH9wQwqGsYWRDik13Z00LL563TxrEfL7YPoPvBygYTb/iEA18AQPDwbAeYzzzYPj19S3w5fHJ6y4kZH19q22MCTSoTRL8e1i84I/G4bjx8feoRrgP9xFVN2WBqqgt4vHpq4O5z++gTjgL4Q8J3+vXG0Tw8nNdd7zN6970XDweMMTvtZDoRrqslX4CyTlDxKvCMmdXNeq46jNMvNYLm+sUYri9ZEx/3t++ZnjjWdQ+kd4LaU6fztW7q2w0K36yyMj7cINTdPm5MvXc11cePac74BWLNXbCzhwfv2Ivn/9FU0k2bjC4U6DQBy1/icMzT6GBXGj8gAt5BtwWsbO+uvWMnmfX9QBitG5thgk7grUgym7ZPv+7qEy0gsf0sdssGOG5v/mIu/SlN++5fO3vhBbNOq57rjCEtnfuuZT9FVi+pnHIiP7NFfeW8vdCrR5f/r3tq3vKexF63ty/Xfe5k8A3oCW99ASnG7qCReyTry/vWKdvNiMbJWfEVbOfULeOkkYp/nTnz8HfPv31y+zndnur3fLxMRjF7zUILx3vTw/6hbzjsAML4Gm4B1fulLMX9nnEYt/l76NCSQDPchd5xB0Kz7xrUnjmym4+izMrv/yMBk8pU055bLT88C2JRbRwWdm8rxrDiRsIpsczGcieAKYVZLvra4/2xpNv+2Ww0++ONGciXmGUfqT+XsjZIAE4gEI0ux8H2bUNmxF7ewdFiDzNHNgD/CPUHPaGyKifQ3xDdQhnJH26u/po5+PJry+hJPDY8L3wyLb9nJAP0Y3XC2ksmk4uN11y7MhON0lzcpltXgW9/gtIUHJC+x5wG64AHOBK2M/DJ1kbb4NnB5Afwf+t/FzrXOHpTb/F3Xy6kA88FT4oS1YSCwePDWl6UU7IEXhcULepaLZZlJ1OhT3ZmNSujDcPYZ/xYfiXURT2wShOmstip1HmWV1LBPPAaXnAAyeAnMHpYrxd7nb2sEcowl5SOGmDHYEir0/csvMoTw0YK6+XVNgZZ3nueQn7ediL90LvjsI4vckttIDj1857nw0cKJASiGoHpBhXKSlZt6lOvIM9H3tVdrPo2hUOYy+ewzR5CDwqZZOGVnqkTZtQZkpqn+1cBd6CWlaFzFHgl+vSg/UufQ4RdqGslNzxaMeJB6WitiV/ZwIPjmPwGnTlvXdePETQpTNOQWB4cb8Cjke3bEkWtS75ywK/tvbwgUJ1BO7o8JSsyrtWefEQMogxU6y+rwD/HqIeKmXOlFK8I3J5Wk5C3dMI7RLsMhYqxDQdFxYu3MdlT8g235+3zej3U/tsc+nkRe3TKPN8fX2rH+/HKZza13PnzUYUOtl36WHHC6s9qCC8AYTMMoC0IJyhxv1bk8neDfXBo92PhW0+yxr+3ApHCtRQK8xlMC8Zrz/xJxuznzUJE824bISP3/ODeX+YiR3M/2Mfol35v4FDkoljzfQEh+qKmfRV57CleUc4BpCG2DZ9f3Lw4cO1G48OZ9+QM8i7r5/Rde1AGgzwDHgDioJC0TS2hnyeG9GsIwzDnqf1fVeCQgur96CCcDiGzk7qqSSCOrxlvm33T5PPWorcfLYwsVjQd/3BSf47lHkmCvDfdaSf6PqFXmjzFGdpdlbPrtnl36+tbgU2tWVA4f6xxetH9qnS2Wca22Ti89NfwD47/Ng8NznxjNmgevkHMz4872A1Qtw5ZEJ35G2H4ZlKhmYoHMMbMQJIAXmATweDV3uQEjZ+Eqe+0eFRFQQ+rVgI6Ynt0xreY3M8eNWDBVjIPhXw+z4A10ydjQdX3bAb00OVTwByNUJHaK0rlTUz9dpT7D6dhiO4CmNqYZ/Bnug3M74D0+JwpYXFYnDy6wNpS5cfae2TnY6s9tgskHUXRIXmHMLvyaOxc91MrFkNslVUec4JnvIqFZpp6ZSF4jx4mmXRNJ7tcNEwKKnA85S3iA15TSeN1x7dhDNwOs6TOutOwWNwiDbjjZtKADdK3GNRcuV9daBKTKeOdg/h6e5x9rFEFngv9Hihr3SesR9OtkEogo7NwezJuroJs8BfUwf/Kjp/uvPnH8ENBx8SVKZslucOUeqTqx6SQVVqzay3t7h2S2DzGJeDh4kHkLOZVUoSDSIhW+KNgYHNY4xGpzfhiZnwjMDK+Zgo7eQ9eeE40ThpnLgrow7BES1oBVABaBGmA5bQeoVz4eVOQC7XRWwxYN6BkDsa9H2rB1DozHV/BZ5d2jqGbrLosJ/U4WicuB8PX93YwzUtoQ7bUAWUsho87LXnltqlyuO9h2HYByF3aJ3Dbhyhyqfct7Z2PDLXA0R4n/TYxol7hEEnHhl5HAFUAGVpdHl47TMcr4vYMGx6r9wi4NCmAmVjn2d5OR4pbHM5DoFmBlpsmGtEnvtl4h1cma9mK6VcLaBkRrwuYLU24JlxH3LEoHlp2fjZASjCXgA++LZiOLRpMr0oE4i0o5P0+Hg2n1kmmA71KOmxjRR3A+rMg+yhi/6/UHLSDJ7cFxVVNP0tVNzJe/wnCLljtAosx2Yn9FqfISds2/llPZtvqfAfSY9tZFhGGxyBAyhW+D9Qcnjw2BxPxvwFcqYMsW4KRSUeREJ26LR1ZEqKctO0OxGNFHfyXkfQULSlsSGaEeRMHOuWsEgDwQLF0AlKF+bwNXNBtdnYiTuoYkQWRdybiEZVL3EvkEaKewihGJAgCLWmkeJeu6mfHVYecWEZQKrwJtmCsDhoCluYb6a4e27EvQoZFsYyzFJEBlCadE2hHqBy39g+TyisOYKCaKS4R221HFCFDAtuMWZzPH2m3KtdpkjXFOpDrdZauFsXFEQzF1SVug0OQMTc0wZtaYUt2w0Vme+yuxENIu4NpUgxdIHNpqOsaeQmJgVuxMNA/mmDtnD1xfXVLfaOEoc9lMZNyLPeumXtG6E+sPNh2TqQ49r7hWV13cBg+Dq/cXOJxol7mnK3SdG6uLu0DWi5hRqV4t2iPcgB7sCjIGUjEaHypHE+UKtD11Uhq0jjwjJGmy44YjKZFHaXtgIxcWW5mOWoK3wOpO2bKdQHtJwl0hqa2MwcGifuWmlXU/7qVBG0L13KA+gFOCZ1X1ehXqB11dZOXs5HlWhUWCZuWhuAA4qowZIWnsLaTn2J4O7Kw97HU3fdmMhrPwKh8UzM5KDltZ7bPIacj+ft9uaGKweLtQMt694MTovtvdusmHuKvqFJQYRDqBDcVUYpu+ksxd6fkYfkpOvN2sojei/1KholpIMFem11q2+zLkS0W/4S2/NTyJi1Ns0KFLxQdjUhD6BgGhOWcem1M3nXPF+UuCekNeQhvW1nXD+bhV0p7IEgzEjTkQtx527kJGRHtMDv2YckUWE+3aGuQRswDhpGu3jO9EQ7Hh167VBEzfMFmU5fUxngMk2Zj9bXs8l9F2EX5hHPDq0TFEhUe1kJPAt7HCoMbB7HbSnLkL3jn5y82aGp9pkyKpPORErjy4+DNz0oES295HbKj8Y2+6QUeKHfC70wzXUPwMAnGkQUg/81VQs+vuH63hJNdaMcekH4DSTUT2mmaL0OwwJPa0qdcTjeHqZ0ujgUo7yQPfYALMmzLeV1RDF3usv0IKc85ryJwjEKd8AhnglThTiKhnOK11Ye7trG3mfEg6hL1rybtI8li/qSXnpi6JqoZhdwE26Avd8UsfcZHZphfib7PCCR300q8tE+GC/qAtaFFJCwHw7yaiZ/A7VeUOVpFarwuW1rLDuwX7WQzHk49r6kW49RpV6PCHixiQYR3yD6JjTvNOiRB+MzPi/c3zKE1jJq7NBN5D4Zf5urcrq9JkJd8ENvm2aXnyB9IbkuiXyX7LOPnGJpYOjDZHT+gDF4bU97t8lZ6UC6G8kUhDPfjDNf0E1LbcX9XLzMrXeIqvCFk0WIMhPWHm6nmf5eIqB/Xe3pLv9Agg40oGC2kXyWaSCiLthwbnZplRo5B3YuOuSVR7Z5Hs4qQfa5F4QcmN0Pp+Vx9GqZLZN2IcQWXjg5LskUbBF4+otpshMEIQcGp6/3Ui7+54jZp3FUqvBs7cS9TTGzPIQ9Qpfd4JIzXXepz+cR6sU4nPC6WSnLe5DX3z8+eeN0XS8NtRL39dWfn/ge5CLs7LXryeQAasTxyetuGQSezy0NmGrU6RFygcOHtDC6ASUTeAozDm+FkwdQQmoh7pyBsbb66C1NjfZUXh18yGuv8kLqVRQu8LQopQ0P4nKWcBWKYybwCKoku8Hx5e/o/fRLWlOq8uI+9dZbn/PMl2bP8uOg2LoRLmGBLyoGr5TZruNNU8gGFvjBya8Pil4jUvT6PE7KKuxMJcWdPXXOX19f3fqcq7ceU5ZNCi7hGLwB84BvZJAH5LHTgN34ePKmUjV6hGKI1ogQtnOzz5goZMh2WgHnrlLizrvGeGsxe+qcWw15LJr+loM6ZMgk4YSEVhtvw3WYhhekPDO+Iw0XBBt4HLJ9mjzKnUydj93fVchOS53nzhtgvkGr4/l4G4zaJEEPOB+1qFzpaBHVjBuVMsh5xvSl+1P7l17oTXp0FjIpUxHBA0bjbtlSyITqENvnDtnnXub2yUxtdJ8WTff6pxXp1xCTi7hHW869pReYbLv5Mp1QLvQV8AYYj3+DqhS7Xzgc09R48EWRH+8o1PfT7mplT53+e3fLTA6uHDAh7oY62QaxpfDijsO5xxiv/02H25AQbbJp1KyMOgx18tCBZ1TibJCv8PVMYyvxZ6L1jGzFyeIaMUmuU1ou2KcOO+RlP1agOpCSRDaaAUaZp4g6cVh5jOafSY91Lpks7C2/dUQnKpMqgsVh9suYy1okUWXIkK6rwg7d+H5UqLgUQXDhoGmM8owG2jBEeP8HMz4s8yKUUB86pD3/8rwO2SXZKNyjXy3HNnpRTCMb5b7C5kuIelgXG3Uu7iu08OlN4+OVJcqOOX31RxAEQagIjeuhakscZ98AQRCECiHifh3xhhrJuxYEoWqIuF8FCTsYEGEXBKGSiLjPIxb24+ErqW8iCEIlEXG/jAi7IAg1oNadmGyZLZ5KKEYQhKojnnsMl+4UYRcEoS6IuEeYfS7dKcIuCEJdaHZYhuPrHjw9Pn5zAIIgCDWiseLOtSN8M9kuU0NbQRCErGieuLO3DvB0cPr6AARBEGpKc8T9fOlOKVwlCELNqb+4V7gesyAIQlrqK+4i6oIgNJjaiXteRfYFQRDKTC3E/YKgSzxdEATBvbhPW3tlu1eKxHyoAN/XqWuKIAhCluTSmXRt7WFPoXqW+AE47TmJCkcK1AgRvxj66nkw/P14PBIxFwRBuJ7/AOlTcXSV7axZAAAAAElFTkSuQmCC';
        $html = $view->make('visiosoft.module.payment::invoice', [
            'logo' => $base64Image,
            'payment' => $payment,
            'details' => $details,
            'started_at' => date('Y-m-d H:i', $startedAt),
            'ended_at' => date('Y-m-d H:i', $endedAt),
            'customer_name' => $customer['customer_name'],
            'customer_email' => $customer['customer_email'],
            'payment_status' => $payment->status->name,
            'source_of_collection' => ''
        ])->render();
        $pdf = Pdf::loadHTML($html)->output();
        $fileName = 'invoices/park_session_' . $payment->id . '_' . date('Y-m-d_H-i') . '.pdf';
        $file = Storage::disk('local')->put($fileName, $pdf);
        $paymnet2 = $paymentRepo->find($payment->id);
        $paymnet2->update(['invoice_file_id' => $file->id]);
        return config('app.url') . '/files/' . $file->path();
    }

    public function retrieveInvocieUrl(PaymentModel $payment)
    {
        return config('app.url') . '/files/' . $payment->invoiceFile()->first()->path();
    }
}
