<?php namespace Visiosoft\PaymentModule\Payment\Contract;

use Anomaly\Streams\Platform\Entry\Contract\EntryRepositoryInterface;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Collection;

interface PaymentRepositoryInterface extends EntryRepositoryInterface
{
    /**
     * @param array $params
     * @return object
     */
    public function getDetail(array $params): object;

    /**
     * @param string $plate
     * @param int $park_id
     * @return object
     */
    public function listByPlateAndPark(string $plate, int $park_id): object;


    /**
     * @param $userID
     * @return numeric | false
     */
    public function getUserDept($userID);

    /**
     * @param bool $isOpenQuery
     * @param int $userID
     * @param array $statuses
     * @param array $orderBy
     * @return Builder[]|Collection
     */
    public function getPayments(bool $isOpenQuery, int $userID, array $statuses, array $orderBy);
}
