<?php namespace Visiosoft\PaymentModule\Listener;

use Monolog\Handler\StreamHandler;
use Monolog\Logger;
use Visiosoft\PaymentModule\Event\PaymentCreatedEvent;
use Visiosoft\PaymentModule\Helper\PaymentChannel;
use Visiosoft\PaymentModule\Payment\Contract\PaymentRepositoryInterface;

class PayCreatedListener
{
    public function handle(PaymentCreatedEvent $event)
    {
        $paymentRepository = app(PaymentRepositoryInterface::class);
        try {
            $paymentRepository->doPay($event->paymentID, PaymentChannel::SYSTEM);
        } catch (\Exception $e) {
            $log = new Logger('create_invoice_listener');
            $log->pushHandler(new StreamHandler(storage_path('logs/create_invoice_listener.log')), Logger::ERROR);
            $log->error($e);
        }
    }
}