<?php namespace Visiosoft\PaymentModule\Listener;

use Monolog\Handler\StreamHandler;
use Monolog\Logger;
use Visiosoft\PaymentModule\Event\PaymentReceiptEvent;
use Visiosoft\PaymentModule\Payment\Commands\Invoice;

class CreateReceiptListener
{
    public function handle(PaymentReceiptEvent $event)
    {
        try {
            $invoice = new Invoice();
            $invoice->createReceipt($event->paymentID);
        } catch (\Exception $e) {
            $log = new Logger('create_receipt_listener');
            $log->pushHandler(new StreamHandler(storage_path('logs/create_receipt_listener.log')), Logger::ERROR);
            $log->error($e);
        }
    }
}
