<?php

namespace Visiosoft\PaymentModule\Helper;

abstract class PaymentChannel
{
    const ADMIN = 0;
    const USER = 1;
    const SYSTEM = 2;
    const QR_PAYMENT = 3;

    private static array $channels = [
        self::ADMIN => 'ADMIN',
        self::USER => 'USER',
        self::SYSTEM => 'SYSTEM',
        self::QR_PAYMENT => 'QR_PAYMENT'
    ];

    /**
     * @param $type
     * @return string|null
     */
    public static function getPaymentChannel($type): ?string
    {
        if (isset(self::$channels[$type])) {
            return self::$channels[$type];
        }
        return null;
    }

}