# Introduction
Solution to payment processes of your projects. Use with card save and
payment providers.


## How To Develop Saved Credit Card & Payment Integration

First of all you have decide what is your needs and what are you expecting
from your payment integration. After that you can start developing your
integrations but you have to be careful, your **PAYMENT & CARD INTEGRATION
MUST SUPPORT EACH OTHER.**

### How To Develop Payment Integration

#### Card Save
- Create an extension with pyro-cms using this command
  `php artisan make:addon visiosoft.extension.xyz_integration`.
- Add
  ``protected $provides = 'visiosoft.module.payment::card_save_provider.xyz_integration';``
  into extension class. (eg. xyz_integration-extension/src/XyzIntegrationExtension.php)
- Select the extension as a provider in the payment module settings from
  admin panel (settings > modules > payment-module).
- Add these functions into the extension class and you **MUST USE
  SAME FUNCTION NAMES.**
  (eg. xyz_integration-extension/src/XyzIntegrationExtension.php)
```php
    // Example Giving From Craftgate Extension
        protected $provides = 'visiosoft.module.payment::card_save_provider.craftgate';

    /*
     * Save card to database and also send to craftgate
     *
     * params: $cardHolderName, $cardNumber, $expireYear, $expireMonth, $cardAlias, $cardUserKey
     * return: object
     */
    public function save($cardHolderName, $cardNumber, $expireYear, $expireMonth, $cardAlias = null, $cardUserKey = null)
    {
        try {

            return $this->getProvider()->createCard($cardHolderName, $cardNumber, $expireYear, $expireMonth, $cardAlias, $cardUserKey);

        } catch (\Exception $e) {

            $this->logError($e);

            return $e->getMessage();

        }
    }

    /*
     * Get users all cards from database
     *
     * return: object
     */
    public function getUserCards()
    {
        try {

            return $this->getProvider()->retrieveUserCards();

        } catch (\Exception $e) {

            $this->logError($e);

            return $e->getMessage();

        }
    }

    /*
     * Get default card from database
     *
     * return: object
     */
    public function getDefaultCard()
    {
        try {

            return $this->getProvider()->retrieveDefaultCard();

        } catch (\Exception $e) {

            $this->logError($e);

            return $e->getMessage();

        }
    }

    /*
     * Get default card from database
     *
     * params: $cardID
     *
     * return: object
     */
    public function updateDefaultCard($cardID)
    {
        try {

            return $this->getProvider()->updateDefaultCard($cardID);

        } catch (\Exception $e) {

            $this->logError($e);

            return $e->getMessage();

        }
    }

    /*
     * Delete card from database and also send delete request to craftgate
     *
     * params: $cardID
     * return: boolean
     */
    public function deleteCard($cardID)
    {
        try {

            return $this->getProvider()->deleteCard($cardID);

        }
        catch (\Exception $e) {

            $this->logError($e);

            return $e->getMessage();

        }
    }


    /*
     * Get Card Provider instance from CardProvider class
     *
     * params: $userId
     * return: object
     */
    public function getProvider()
    {
        try {

            return new CardProvider();

        } catch (\Exception $e) {

            $this->logError($e);

            return $e->getMessage();

        }
    }

    /*
     * Logging errors to storage folder
     *
     * params: $error
     * return: void
     */
    public function logError($error)
    {
        return $this->getProvider()->logError($error);
    }

```
- Example Of All Requests and Responses in JSON format.
```json
// Get Cards
{
    "id": 13,
    "user_token": "abcde",
    "card_holder_name": null,
    "service": "craftgate",
    "default": 1,
    "card": {
      "brand": "VISA",
      "exp_month": null,
      "exp_year": null,
      "expired": "NOT_EXPIRED",
      "last4": "0002"
    }
  },
  {
    "id": 14,
    "card_holder_name": null,
    "service": "craftgate",
    "default": 0,
    "card": {
      "brand": "TROY",
      "exp_month": null,
      "exp_year": null,
      "expired": "NOT_EXPIRED",
      "last4": "0007",
       "token": "token" 
    }
  }
}               


// Get Default Card
{
  "id": 13,
  "card_holder_name": "Unregistered User",
  "service": "craftgate",
  "default": 1,
  "card": {
    "brand": "VISA",
    "exp_month": null,
    "exp_year": null,
    "expired": "NOT_EXPIRED",
    "last4": "0002",
    "token": "token"
    }
}


// Post Create Card
{
  "options": {
    "parameters": {
      "card": {
        "card_number":"5105105105145100",
        "expire_month":"02",
        "expire_year": "2027",
        "cvc": 555
      }
    }
  }
}
// Success
{
  "success": true,
  "response": {
    "id": 25,
    "card_holder_name": "Unregistered User",
    "service": "craftgate",
    "default": false,
    "card": {
      "brand": null,
      "exp_month": null,
      "exp_year": null,
      "expired": "NOT_EXPIRED",
      "last4": "5100",
      "token":"token"
    }
  },
  "message": "",
  "error_code": 0
}
//Failure
{
"success": false,
"response": [],
"message": "Please check your information and try again.",
"error_code": ""
}


//Post Update Default Card
{
  "options" : {
    "parameters": {
      "card_id": 2
    }
  }
}
//Success
{
  "success": true,
  "response": {
    "id": 22,
    "card_holder_name": "Unregistered User",
    "service": "craftgate",
    "default": 1,
    "card": {
      "brand": null,
      "exp_month": null,
      "exp_year": null,
      "expired": "NOT_EXPIRED",
      "last4": "5100",
      "token":"token"
    }
  },
  "message": "",
  "error_code": 0
}
//Failure
{
  "success": false,
  "response": [],
  "message": "Card not found!",
  "error_code": ""
}


//Post Delete Card
{
  "options": {
    "parameters": {
      "card_id": 1
    }
  }
}
//Success
{
  "success": true,
  "response": true,
  "message": "",
  "error_code": 0
}
//Failure
{
  "success": false,
  "response": "Card not found",
  "message": "",
  "error_code": 0
}

```
- The functions inside extensions class MUST DEFINED in card extension  
  and you should edit according to your needs.
- You can use this example to develop your own card save extension.
- You can use your saved card with your payment integration but
  you have to be careful if you use different providers, your
  **PAYMENT & CARD INTEGRATION MUST SUPPORT EACH OTHER.**

#### Payment Integration
- After you set your card save extension, now continue with payment
  extension(integration) and don't forget to add
  ``protected $provides = 'visiosoft.module.payment::payment_provider.xyz_payment';``
  into extension class. (eg. xyz_integration-extension/src/XyzIntegrationExtension.php)
- Add these functions into the extension class and you **MUST USE
  SAME FUNCTION NAMES.**
  (eg. sipay-extension/src/SipayExtension.php)
```php
// Example From Sipay Extension
    protected $provides = 'visiosoft.module.payment::payment_provider.sipay';

    // This function is used to start the payment process without saved card.
    public function pay(
    $cc_no,
    $cc_holder_name,
    $exp_year,
    $exp_month,
    $cvv,
    $total,
    $items,
    $currency,
    $invoice_id,
    $buyer_name,
    $buyer_surname)
    {
        // Since this process starts the Auth process, it must be called first.
        $connector = new \Visiosoft\SipayExtension\Commands\Connector();

        $card = new Cards();
        $card->createCard($cc_no, $cc_holder_name, $exp_year, $exp_month, $cvv);

        $sipay_items = new Items();
        foreach ($items as $item) {
            $sipay_items->addItem($item['name'], $item['price'], $item['quantity'], $item['description'] ?? '');
        }

        $invoice = new Invoice($invoice_id, $buyer_name, $buyer_surname);

        $pay = new Pay($card, $total,$sipay_items, $connector, $invoice, $currency);
        $result_pay = $pay->pay2D();

        if ($result_pay['payment_status'] == 1) {
            if ($result_pay["transaction_type"] == "Auth") {
                // Payment Success
                return true;
            } else if ($result_pay["transaction_type"] == "Pre-Authorization") {
                //  /api/confirmPayment
                $pay->confirm();

                return true;
            }
        } else {
            // payment_status == 0
            return false;
        }
    }

    // This function is used to start the payment process with saved card.
    public function payWithSaved(
    $card_token,
    $items,
    $currency,
    $invoice_id,
    $buyer_name,
    $buyer_surname,
    $buyer_phone,
    $buyer_email,
    $buyer_id)
    {
        // Since this process starts the Auth process, it must be called first.
        $connector = new \Visiosoft\SipayExtension\Commands\Connector();

        $sipay_items = new Items();
        foreach ($items as $item) {
            $sipay_items->addItem($item['name'], $item['price'], $item['quantity'], $item['description'] ?? '');
        }

        $invoice = new Invoice($invoice_id, $buyer_name, $buyer_surname, '', $buyer_phone, $buyer_email, $buyer_id);

        if (!setting_value( 'visiosoft.extension.sipay::live')) {
            $card_token = setting_value('visiosoft.extension.sipay::dev_mode_token','a4f8173943bfddd48967c18b3b6b850f');
        }

        $pay = new PayBySavedCard($card_token, $sipay_items, $connector, $invoice, $currency);
        $result_pay = $pay->payByCardToken();

        return $result_pay;
    }

    public function logError($e)
    {
        $log = new Logger('sipay');
        $log->pushHandler(new StreamHandler(storage_path('logs/sipay.log')), Logger::ERROR);
        $log->error($e);
    }
```
- Parameters are coming from the payment-module. You can use them as you wish.
- After you set your payment extension and fill with parameters you need,
  now you can use card save extension with payment-module.
```php
// Pay By Saved Card
{
      "provider_user_id": "1",
      "default_card_id": "1",
      "price": 100.00,
      "currency": "TRY",
      "items": [
        [
          "name": "Charging Service",
          "description": "Charging Service Description",
          "price": 100.00,
          "quantity": 1,
          "tax": 0,
          "tax_rate": 0,
          "taxed_price": 0,
          "discount": 0,
          "discounted_price": 0,
          "shipping": 0,
          "subtotal": 100,
          "total": 100
        ]
      ],
      "buyer": {
        "id": "1",
        "first_name": "Test",
        "last_name": "Test",
        "email": "
        },
      "invoice_id": "1",
}
// Success
[
    'status' => 'success',
    'data' => [
        'payment_intent_id' => 1
    ]
]
// Failure
[
    'status' => 'fail',
    'data' => [
        'payment_intent_id' => 1
    ]
]
```


#### Card Save And Payment Integration Combined Usage

- if you want to use both card save and payment processes together,
  you must change your provider variable inside extension class.
- Example usage ``protected $provides = 'visiosoft.module.payment::save_or_pay_provider.stripe';``
- Then defining this variable you can use both card save and payment functions together.