<?php namespace Visiosoft\PaymentModule\Payment;

use Carbon\Carbon;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Support\Facades\Auth;
use Visiosoft\ConnectModule\Command\CheckRequiredParams;
use Visiosoft\PaymentStripeExtension\PaymentStripeExtension;

class PaymentApiCollection extends PaymentRepository
{
    use DispatchesJobs;


    public function createCard(array $params)
    {
        $create_card = PaymentStripeExtension::createCard($params);
        return $create_card;
    }

    public function cards($params)
    {
        $cards = PaymentStripeExtension::cards($params);
        return $cards;
    }

    public function createDraftPayment(array $params)
    {

        $create = $this->newQuery()->create([
            'user_id' => $params['user_id'],
            'transaction_id' => $params['transaction_id'],
            'amount'=>$params['amount'],
            'usage'=>$params['usage'],
            'status'=>1
        ]);

        if (!$create)
        {
            throw new \Exception(trans('visiosoft.module.payment::message.transaction_create_failed'), 400);
        }

        return $create;
    }


    public function createPayment(array $params)
    {

        $payment = $this->newQuery()->where('transaction_id', $params['transaction_id'])->first();

        $payment_params = ['currency'=>"sek",'amount'=>$payment['amount'],'method_id'=>$params['method_id']];

        $create_payment = PaymentStripeExtension::createPaymentIntent($payment_params);
        $payment->update(['payment_intent_id' => $create_payment['id']]);
        return $this->confirmPayment(['payment_id'=>$create_payment['id']]);
    }

    public function confirmPayment(array $params)
    {
        $confirm_payment = PaymentStripeExtension::confirmPaymentIntent($params);
        $payment = $this->newQuery()->where('payment_intent_id', $params['payment_id'])->first();
        if ($confirm_payment['status'] == "succeeded") {
            $payment->update(['status_id' => 2]);
        } else throw new \Exception("Payment Failed", 404);
        return $payment;
    }

}
