<?php namespace Visiosoft\PaymentModule\Payment\Commands;
use Visiosoft\PaymentModule\Payment\Contract\PaymentRepositoryInterface;

class Invoice extends Provider
{

    /**
     * @var mixed
     */
    public function __construct()
    {
        parent::__construct('invoice_provider');
    }

    /**
     * @param $paymentId
     */
    public function createInvoice($paymentId)
    {
        try {
            if (method_exists($this->provider, 'storeInvoice')) {
                $payment = app(PaymentRepositoryInterface::class)->find($paymentId);

                $storeInvoice = $this->provider->storeInvoice($payment);
                if (!$storeInvoice) {
                    return $this->formatOutput(false, []);
                }
                return $this->formatOutput($storeInvoice, []);
            } else {
                return $this->formatOutput(false, []);
            }
        } catch (\Exception $e) {
            $this->provider->logError($e);
            return $this->formatOutput(false, []);
        }
    }

    /**
     * @param $paymentId
     */
    public function createReceipt($paymentId)
    {
        if (method_exists($this->provider, 'storeReceipt')) {
            try {
                $payment = app(PaymentRepositoryInterface::class)->find($paymentId);

                $storeReceipt = $this->provider->storeReceipt($payment);
                if ($storeReceipt) {
                    return $this->formatOutput($storeReceipt, []);
                }
            } catch (\Exception $e) {
                $this->provider->logError($e);
            }
        }
        return $this->formatOutput(false, []);
    }

    /**
     * @param $id
     * @param $category
     * @param $amount,
     * @param $currency,
     * @param $tax_percent,
     * @param $company_id,
     * @param $organization_number,
     * @param $user_id,
     * @param $display_name,
     * @param $phone,
     * @param $city,
     * @param $email,
     * @param $extended_address,
     * @param $zip_code,
     * @param $country
     */
    public function createInvoiceWithParams($id, $amount, $quantity, $tax_percent, $user_id, $display_name, $phone,
                                            $city, $email, $extended_address, $zip_code, $country,
                                            $organization_number)
    {
        try {
            if (method_exists($this->provider, 'storeInvoiceWithParams')) {
                $storeInvoice = $this->provider->storeInvoiceWithParams($id, $amount, $quantity, $tax_percent, $user_id,
                    $display_name, $phone, $city, $email, $extended_address, $zip_code, $country, $organization_number);
                if (!$storeInvoice) {
                    return $this->formatOutput(false, []);
                }
                return $this->formatOutput($storeInvoice, []);
            } else {
                return $this->formatOutput(false, []);
            }
        } catch (\Exception $e) {
            $this->provider->logError($e);
            return $this->formatOutput(false, []);
        }
    }
}