<?php namespace Visiosoft\PaymentModule\Console\Command;

use Illuminate\Console\Command;
use Visiosoft\PaymentModule\Job\AutoInvoiceJob;
use Visiosoft\PaymentModule\Payment\PaymentWithoutAttrModel;
use function Clue\StreamFilter\fun;

class AutoInvoiceCommand extends Command
{
    protected $signature = 'invoice:auto {userId?} {date?}';

    protected $description = 'auto charge over limit';

    public function __construct()
    {
        parent::__construct();
    }

    public function handle()
    {
        $limit = setting_value('visiosoft.module.payment::minimum_payable_amount');
        $unregisteredUserId = setting_value('visiosoft.module.vehicle::default_customer');
        $userId = null;
        $date = null;
        if (!empty($this->argument('userId'))) {
            $userId = $this->argument('userId');
        }
        if (!empty($this->argument('date'))) {
            $date = $this->argument('date');
        }
        $payments = PaymentWithoutAttrModel::with([
            'category',
            'parkSession',
            'chargingTransaction',
            'parkSession.park' => function ($parking) {
                $parking->select(['id', 'address', 'phone', 'name', 'operator_id']);
            },
            'parkSession.park.operator' => function ($operator) {
                $operator->select(['id', 'title']);
            },
            'chargingTransaction.station' => function ($station) {
                $station->select(['id', 'title as name', 'operator_id', 'address_line_1 as address']);
            },
            'chargingTransaction.station.operator' => function ($operator) {
                $operator->select(['id', 'title']);
            },
            'chargingTransaction.connection' => function ($connection) {
                $connection->select(['id', 'name']);
            }
        ])
            ->whereIn('status_id', [1, 4]) //payment statuses: 1 = unpaid 4 = failed
            ->whereNull('invoice_id')
            ->whereNull('company_id')
            ->where('user_id', '!=', $unregisteredUserId)
            ->orderBy('created_at', 'desc');
        if ($userId) {
            $payments = $payments->where('user_id', $userId);
        }
        if ($date) {
            $payments = $payments->where('created_at', '>=', $date);
        }
        $payments = $payments->get();
        if (!empty($payments)) {
            $userPayments = $payments->groupBy('user_id')->toArray();
            foreach ($userPayments as $userId => $userPayment) {
                $amount = 0;
                foreach ($userPayment as $item) {
                    $amount = $amount + $item['amount'];
                }
                if ($amount >= $limit) {
                    AutoInvoiceJob::dispatch($userId, $userPayment);
                }
            }
        }
    }
}