<?php namespace Visiosoft\PaymentModule\Console\Command;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;
use Visiosoft\PaymentModule\Event\PaymentCreatedEvent;
use Visiosoft\PaymentModule\Helper\CommonHelper;
use Visiosoft\PaymentModule\Job\AutoInvoiceJob;
use Visiosoft\PaymentModule\Payment\Contract\PaymentRepositoryInterface;
use Visiosoft\PaymentModule\Payment\PaymentWithoutAttrModel;
use function Clue\StreamFilter\fun;

class AutoPaymentCommand extends Command
{
    protected $signature = 'payment:auto_payment';
    protected $description = 'A cron for automatic payment';
    protected $helper;

    public function __construct(CommonHelper $commonHelper)
    {
        $this->helper = $commonHelper;
        parent::__construct();
    }

    public function handle()
    {
        $automaticWithdrawal = setting_value('visiosoft.module.payment::automatic_withdrawal');
        if ($automaticWithdrawal){
            $unpaidPayments = $this->getUnpaidPayments();
            if (!$this->helper->propertyIsEmpty($unpaidPayments)) {
                foreach ($unpaidPayments as $unpaidPayment) {
                    event(new PaymentCreatedEvent($unpaidPayment->id));
                }
            }
        }
    }

    protected function getUnpaidPayments()
    {
        $tryInterval = setting_value('visiosoft.module.payment::automatic_withdrawal_try_interval');
        $nowMinusTryInterval = date('Y-m-d H:i:s', strtotime('-' . $tryInterval . ' minutes', time()));
        return DB::table('payment_payment')
            ->whereIn('status_id', ['1,3'])
            ->whereNull('deleted_at')
            ->where(function ($query) use ($nowMinusTryInterval) {
                $query->whereNull('last_try')
                    ->orWhere('last_try', '<', $nowMinusTryInterval);
            })
            ->limit(100)
            ->get();


    }
}
