<?php namespace Visiosoft\PaymentModule\Payment;

use Visiosoft\ChargingModule\Transaction\TransactionModel;
use Visiosoft\ParkingModule\ParkingSession\ParkingSessionModel;
use Visiosoft\PaymentModule\Payment\Contract\PaymentInterface;
use Anomaly\Streams\Platform\Model\Payment\PaymentPaymentEntryModel;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Visiosoft\VehicleModule\Vehicle\VehicleModel;

class PaymentModel extends PaymentPaymentEntryModel implements PaymentInterface
{

    protected $appends = [
        'charging_transaction', 'park_session', 'vehicle', 'payment_category', 'payment_status', 'user'
    ];

    public function getUserAttribute()
    {
        return $this->user()->first();
    }

    public function getParkSessionAttribute()
    {
        return $this->parkSession()->first();
    }

    public function getChargingTransactionAttribute()
    {
        return $this->chargingTransaction()->first();
    }


    public function getPaymentCategoryAttribute()
    {
        return $this->category()->first();
    }

    public function chargingTransaction()
    {
        return $this->belongsTo(TransactionModel::class, 'transaction_id');
    }


    public function parkSession()
    {
        return $this->belongsTo(ParkingSessionModel::class, 'park_session_id');
    }

    public function getVehicleAttribute()
    {
        return $this->vehicle()->first();
    }

    public function vehicle()
    {
        return $this->belongsTo(VehicleModel::class, 'vehicle_id');
    }

    public function getPaymentStatusAttribute()
    {
        return $this->status()->first();
    }
}
