<?php namespace Visiosoft\PaymentModule\Job;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Visiosoft\InvoiceModule\Job\CreateUserInvoiceJob;
use Visiosoft\PaymentModule\Helper\InvoiceHelper;

class AutoInvoiceJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    protected $userId;
    protected $payment;

    public function __construct($userId, $payment)
    {
        $this->userId = $userId;
        $this->payment = $payment;
    }

    public function handle()
    {
        $details = [];
        $payment = $this->payment;
        $invoiceHelper = app(InvoiceHelper::class);
        $user = $invoiceHelper->getUser($payment['user_id']);
        $getVehicleSessions = $invoiceHelper->getVehicleSessions($payment);
        $vehicles = $getVehicleSessions['vehicles'];
        $vehicleSessions = $getVehicleSessions['sessions'];
        $plateImages = $getVehicleSessions['plate_images'];
        if (!empty($vehicleSessions)) {
            foreach ($vehicleSessions as $vehicleId => $sessions) {
                $plate = $vehicles[$vehicleId];
                $vehicle = $invoiceHelper->getVehicle($vehicleId, $plate);
                $images = [];
                if (!empty($plateImages[$vehicleId])) {
                    $images = $plateImages[$vehicleId];
                }
                $details[$vehicleId] = $invoiceHelper->getInvoiceDetails($user, $vehicle, $sessions, $images);
            }
            $mainCreditorUserId = setting_value('visiosoft.module.invoice::main_creditor');
            $creditor = $invoiceHelper->getCreditor($mainCreditorUserId, 'business');
            $creditorUser = $invoiceHelper->getUser($mainCreditorUserId);
            if (!empty($details)) {
                foreach ($details as $detail) {
                    $debtor = $invoiceHelper->getDebtor($detail['user']['id'], 'personal', $creditor->external_id);
                    $debtorUser = $invoiceHelper->getUser($detail['user']['id']);
                    $detail['creditor_external_id'] = $creditor->external_id;
                    $detail['debtor_external_id'] = $debtor->external_id;
                    $detail['creditor_id'] = $creditor->id;
                    $detail['debtor_id'] = $debtor->id;
                    $detail['debtor_phone'] = $debtorUser['phone'];
                    $detail['debtor_email'] = $debtorUser['email'];
                    $detail['creditor_phone'] = $creditorUser['phone'];
                    $detail['creditor_email'] = $creditorUser['email'];
                    $detail['payment_id'] = $payment['id'];
                    $records = $invoiceHelper->generateInvoiceRecords($detail);
                    $detail['invoice_records'] = $records;
                    CreateUserInvoiceJob::dispatch($detail);
                }
            }
        }
    }
}
