<?php namespace Visiosoft\PaymentModule\Status;

use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Visiosoft\PaymentModule\Status\Contract\StatusRepositoryInterface;

class StatusSeeder extends Seeder
{

    /**
     * Run the seeder.
     */
    public function run(StatusRepositoryInterface $statusRepository)
    {
        if (!$statusRepository->newQuery()->where('slug', 'pending')->orderBy('id', 'ASC')->first()) {
            $statusRepository->create([
                'en' => [
                    'name' => 'pending'
                ],
                'slug' => 'pending'
            ]);
        }
        if (!$statusRepository->newQuery()->where('slug', 'paid')->orderBy('id', 'ASC')->first()) {
            $statusRepository->create([
                'en' => [
                    'name' => 'paid'
                ],
                'slug' => 'paid'
            ]);
        }
    }
}
