<?php namespace Visiosoft\PaymentModule\Payment\Commands;
use Visiosoft\PaymentModule\Payment\Contract\PaymentRepositoryInterface;

class Invoice extends Provider
{

    /**
     * @var mixed
     */
    public function __construct()
    {
        parent::__construct('invoice_provider');
    }

    /**
     * @param $paymentId
     */
    public function createInvoice($paymentId)
    {
        try {
            $payment = app(PaymentRepositoryInterface::class)->find($paymentId);
            return $this->provider->storeInvoice($payment);
        } catch (\Exception $e) {
            $this->provider->logError($e);
            return $e->getMessage();
        }
    }

}