<?php namespace Visiosoft\PaymentModule\Helper;

class CommonHelper
{
    /**
     * @param int $duration
     * @return string (hh:mm:ss)
     */
    function format_duration(int $duration): string
    {
        return sprintf('%02d:%02d:%02d', ($duration / 3600), ($duration / 60 % 60), $duration % 60);
    }


    /**
     * @param string $userAgent
     * @return string (android | ios | web)
     */
    public function getDevicePlatform(string $userAgent): string
    {
        $platform = "web";

        $iphone = stripos($userAgent, "iPhone");
        $ipad = stripos($userAgent, "iPad");
        $android = stripos($userAgent, "Android");

        if ($ipad || $iphone) {
            $platform = "ios";
        } else if ($android) {
            $platform = "android";
        }

        return $platform;
    }


}