<?php namespace Visiosoft\PaymentModule\Payment;

use Carbon\Carbon;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Support\Facades\Auth;
use Visiosoft\ConnectModule\Command\CheckRequiredParams;
use Visiosoft\PaymentStripeExtension\PaymentStripeExtension;
class PaymentApiCollection extends PaymentRepository
{
    use DispatchesJobs;


    public function createCard(array $params)
    {
        $create_card = PaymentStripeExtension::createCard($params);
        return $create_card;
    }

    public function cards($params)
    {
      $cards = PaymentStripeExtension::cards($params);
      return $cards;
    }

    public function createPayment(array $params)
    {
        $create_payment = PaymentStripeExtension::createPaymentIntent($params);
        return $create_payment;
    }

    public function confirmPayment(array $params)
    {
        $confirm_payment = PaymentStripeExtension::confirmPaymentIntent($params);
        return $confirm_payment;
    }

}
