<?php namespace Visiosoft\PaymentModule\Payment\Table;

use Anomaly\Streams\Platform\Entry\Contract\EntryInterface;
use Anomaly\UsersModule\User\Contract\UserRepositoryInterface;
use Visiosoft\CurrencyModule\CurrencyModule;
use Visiosoft\PaymentModule\Helper\CommonHelper;
use Visiosoft\PaymentModule\PaymentMethod\Contract\PaymentMethodRepositoryInterface;

class PaymentTableColumns
{

    public function handle(PaymentTableBuilder $builder)
    {
        $columns = [
            'id' => ['wrapper' => '{entry.id}'],
            'user' => [
                'wrapper' => '{value.name}',
                'value' => [
                    'name' => function (EntryInterface $entry, UserRepositoryInterface $userRepository) {
                        $user = $userRepository->find($entry->user_id);
                        if ($user) {
                            return $user->first_name . ' ' . $user->last_name . ' ' . $user->email;
                        } else {
                            trans("visiosoft.module.payment::field.unregistered_user");
                        }
                    }
                ]
            ],
            'plate',
            'payment_amount' => [
                'wrapper' => '{value.payment_amount}',
                'value' => [
                    'payment_amount' => function (EntryInterface $entry) {
                        return $entry->payment_amount . " " . $entry->currency;
                    }
                ]
            ],
            'transaction',
            'payment_method' => [
                'wrapper' => '{value.card}',
                'value' => [
                    'card' => function (
                        EntryInterface                   $entry,
                        UserRepositoryInterface          $userRepository,
                        PaymentMethodRepositoryInterface $paymentMethodRepository,
                        CommonHelper                     $helper
                    ) {
                        $user = $userRepository->find($entry->user_id);
                        $paymentMethod = $paymentMethodRepository->getDefaultCardByOwner($user->id);
                        $noCardMessage = trans('visiosoft.module.payment::message.user_has_no_card');
                        $infoNotAvailable = trans('visiosoft.module.payment::message.info_not_availables');
                        if ($paymentMethod) {
                            $card = $helper->getDataInPaymentMethodJson($paymentMethod->card, 'last4');
                            return !empty($card) ? $card : $infoNotAvailable;
                        } else {
                            return $noCardMessage;
                        }
                    }
                ]
            ],
            'status'
        ];

        $builder->setColumns($columns);
    }
}
