<?php namespace Visiosoft\PaymentModule\Listener;

use Monolog\Handler\StreamHandler;
use Monolog\Logger;
use Visiosoft\PaymentModule\Category\Contract\CategoryRepositoryInterface;
use Visiosoft\PaymentModule\Payment\Contract\PaymentRepositoryInterface;
use Visiosoft\PaymentModule\PaymentMethod\Event\CardCreatedEvent;

class CardCreatedListener
{
    public function handle(CardCreatedEvent $event)
    {
        try {
            $userID = $event->userID;
            $paymentRepository = app(PaymentRepositoryInterface::class);
            $categoryRepository = app(CategoryRepositoryInterface::class);
            $categoryID = $categoryRepository->findBy('slug', 'verification')->getId();

            $paymentRepository->removeOldVerificationPayment($userID);

            $paymentParam = [
                'user_id' => $userID,
                'amount' => 1,
                'usage' => 0,
                'category_id' => $categoryID,
                'invoice_create' => false
            ];

            $payment = $paymentRepository->createDraftPayment($paymentParam);
            if (!$payment) {
                $pay = $paymentRepository->doPay($payment->id);
                if ($pay['data']['status'] == "fail") {
                    return false;
                }
            } else {
                //TODO CREATE A REFUND FUNCTION
            }
        } catch (\Exception $e) {
            $log = new Logger('get_verification_payment');
            $log->pushHandler(new StreamHandler(storage_path('logs/get_verification_payment.log')), Logger::ERROR);
            $log->error($e);
            return false;
        }

    }
}