<?php namespace Visiosoft\PaymentModule\Category;

use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Visiosoft\PaymentModule\Category\Contract\CategoryRepositoryInterface;

class CategorySeeder extends Seeder
{

    /**
     * Run the seeder.
     */
    public function run(CategoryRepositoryInterface $categoryRepository)
    {

        $entries = [
            [
                'en' => [
                    'name' => 'Charging'
                ],
                'sv' => [
                    'name' => 'Laddning'
                ],
                'tr' => [
                    'name' => 'Şarj İşlemi'
                ],
                'slug' => 'charging'
            ],
            [
                'en' => [
                    'name' => 'Parking'
                ],
                'sv' => [
                    'name' => 'Parkering'
                ],
                'tr' => [
                    'name' => 'Park İşlemi'
                ],
                'slug' => 'parking'
            ],
            [
                'en' => [
                    'name' => 'Long term ticket'
                ],
                'sv' => [
                    'name' => 'Långtidsbiljett'
                ],
                'tr' => [
                    'name' => "Uzun süreli bilet"
                ],
                'slug' => 'long_term_ticket'
            ],
            [
                'en' => [
                    'name' => 'Park & Charge'
                ],
                'sv' => [
                    'name' => 'Parkering & Laddning'
                ],
                'tr' => [
                    'name' => 'Park & Şarj İşlemi'
                ],
                'slug' => 'parking_and_charge'
            ],
            [
                'en' => [
                    'name' => 'verification'
                ],
                'sv' => [
                    'name' => 'verifiering'
                ],
                'tr' => [
                    'name' => 'Doğrulama İşlemi'
                ],
                'slug' => 'verification'
            ],
        ];

        foreach ($entries as $entry) {
            if (!$categoryRepository->newQuery()->where('slug', $entry['slug'])->orderBy('id', 'ASC')->first()) {
                $categoryRepository->create($entry);
            }
        }
    }
}
