<?php namespace Visiosoft\PaymentModule\Console\Command;

use Illuminate\Console\Command;
use Visiosoft\PaymentModule\Job\AutoInvoiceJob;
use Visiosoft\PaymentModule\Payment\PaymentWithoutAttrModel;

class AutoInvoiceCommand extends Command
{
    protected $signature = 'invoice:auto';

    protected $description = 'auto charge over limit';

    public function __construct()
    {
        parent::__construct();
    }

    public function handle()
    {
        $limit = setting_value('visiosoft.module.payment::minimum_payable_amount');
        $payments = PaymentWithoutAttrModel::with([
            'category',
            'company',
            'parkSession',
            'chargingTransaction',
            'parkSession.slot',
            'parkSession.park' => function ($parking) {
                $parking->select(['id', 'address', 'phone', 'name', 'operator_id']);
            },
            'parkSession.park.operator' => function ($operator) {
                $operator->select(['id', 'title']);
            },
            'chargingTransaction.station' => function ($station) {
                $station->select(['id', 'title as name', 'operator_id', 'address_line_1 as address']);
            },
            'chargingTransaction.station.operator' => function ($operator) {
                $operator->select(['id', 'title']);
            },
            'chargingTransaction.connection'

        ])
            ->whereIn('status_id', [1, 4]) //payment statuses: 1 = unpaid 4 = failed
            ->whereNull('invoice_id')
            ->whereNull('company_id')
            ->where(function ($query) {
                $query->orWhereHas('chargingTransaction')
                    ->orWhereHas('parkSession');
            })
            ->limit(1000)
            ->get();
        if (!empty($payments)) {

            $userPayments = $payments->groupBy('user_id')->toArray();
            foreach ($userPayments as $userId => $userPayment) {
                $amount = 0;
                foreach ($userPayment as $item) {
                    $amount = $amount + $item['amount'];
                }
                if ($amount >= $limit) {
                    AutoInvoiceJob::dispatch($userId, $userPayment);
                }
            }
        }
    }
}