<?php namespace Visiosoft\PaymentModule\PaymentMethod;

use Illuminate\Support\Facades\Auth;
use Visiosoft\PaymentModule\PaymentMethod\Contract\PaymentMethodRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

class PaymentMethodRepository extends EntryRepository implements PaymentMethodRepositoryInterface
{

    protected $model;

    public function __construct(PaymentMethodModel $model)
    {
        $this->model = $model;
    }

    public function addPaymentMethod(array $params)
    {
        if (!empty($params['billing_details'])) {
            $params['billing_details'] = (string)json_encode($params['billing_details']);
        }

        if (!empty($params['card'])) {
            $params['card'] = (string)json_encode($params['card']);
        }
        $params['metadata'] = null;
        if (!empty($params['metadata'])) {
            $params['metadata'] = (string)json_encode($params['metadata']);
        }
        $this->newQuery()->where('owner_id', Auth::id())->update(['default' => 0]);
        $params['default'] = 1;
        return $this->newQuery()->create($params);
    }

    /**
     * @param $ownerId
     * @param $select (Example : ['id','name','created_at'])
     */
    public function getDefaultCardByOwner($ownerId, $select = ['*'] )
    {
        return $this->model->newQuery()
            ->where('owner_id', $ownerId)
            ->where('default', 1)
            ->whereNull('deleted_at')
            ->select($select)
            ->first();
    }

    /**
     * @param $ownerId
     * @param $select (Example : ['id','name','created_at'])
     * @param $orderBy (Example : ['id','DESC'])
     */
    public function getCardsByOwner($ownerId, $select = ['*'], $orderBy = ['id', 'DESC'])
    {
        return $this->model->newQuery()
            ->where('owner_id', $ownerId)
            ->whereNull('deleted_at')
            ->select($select)
            ->orderBy($orderBy[0], $orderBy[1])
            ->get();
    }

    /**
     * @param $ownerId
     * @param $service
     */
    public function getCustomerIdByService($ownerId, $service )
    {;
        return $this->model->newQuery()
            ->where('owner_id', $ownerId)
            ->where('service', $service)
            ->whereNull('deleted_at')
            ->whereNotNull('customer')
            ->pluck('customer')
            ->first();
    }

}
