<?php namespace Visiosoft\PaymentModule\PaymentMethod\Contract;

use Anomaly\Streams\Platform\Entry\Contract\EntryRepositoryInterface;

interface PaymentMethodRepositoryInterface extends EntryRepositoryInterface
{
    /**
     * @param array $params [
     * (int)    'owner_id' => 'int',
     * (string) 'service' => 'stripe',
     * (string) 'service_payment_method_id' => pm_1MU31QLxoUxL65YUEXsjrT6i,
     * (object) 'card' => {"brand":"mastercard","country":"SE","exp_month":9,"exp_year":2024,"last4":"8314"},
     * (string) 'holder_name' => 'John Doe')
     * ]
     */
    public function addPaymentMethod(array $params);

    public function getDefaultCardByOwner($ownerId, $select);

    /**
     * @param $ownerId
     * @param $select (Example : ['id','name','created_at'])
     * @param $orderBy (Example : ['id','DESC'])
     */
    public function getCardsByOwner($ownerId, $select, $orderBy);

    /**
     * @param $ownerId
     * @param $service
     */
    public function getCustomerIdByService($ownerId, $service);
}
