<?php

namespace Visiosoft\PaymentModule\Payment\Commands;

class Provider
{

    /**
     * @param bool $status
     * @param array $data
     * @param string|null $message
     * @param \Exception|null $e
     * @return array
     */

    public $provider;

    public function __construct($providerType)
    {
        $this->provider = $this->getProviders($providerType);
    }

    public function getProviders($providerType)
    {
        $extensions = app('extension.collection')->installed();
        $providerCollection = setting_value('visiosoft.module.payment::' . $providerType);
        // Checking if the providers are exists.
        if (!($provider = $extensions->get($providerCollection))) {
            throw new \Exception(trans('visiosoft.module.payment::message.provider_not_found'), 500);
        }
        return $provider;
    }

    public function formatOutput(bool $status = true, array $data = [], string $message = null, \Exception $e = null): array
    {
        if (!$status && !empty($e)) {
            $message = 'Internal Error';
            if (config('app.debug')) {
                $message = 'Exception Error: ' . $e->getFile() . ' ' . $e->getLine() . ' ' . $e->getMessage();
            }
        }
        
        return [
            'status' => $status,
            'data' => $data,
            'message' => $message
        ];
    }

    public function getProviderSlug()
    {
        return $this->provider->getSlug();
    }

}

?>