<?php namespace Visiosoft\PaymentModule\Payment\Commands;

use Visiosoft\PaymentModule\Payment\Commands\Provider;

class Pay extends Provider
{

    /*
        Then a Class will be written for them.
        Each Class will perform its own function and then the
        Pay function will be triggered and receive information
        over this Class.
     */
    protected $items;

    protected $card;

    protected $invoice;

    public function __construct()
    {
        parent::__construct('payment_provider');
    }

    public function payByCard($card_number, $card_holder, $exp_year, $exp_month, $cvv, $total, $items, $currency, $invoice_id, $buyer_name, $buyer_surname)
    {
        try {
            return $this->provider->payByCard($card_number, $card_holder, $exp_year, $exp_month, $cvv, $total, $items, $currency, $invoice_id, $buyer_name, $buyer_surname);
        } catch (\Exception $e) {
            $this->provider->logError($e);
            return $e->getMessage();
        }
    }

    /**
     * @param string $providerUserID
     * @param string $defaultCardID
     * @param float $price
     * @param string $currency
     * @param array $items (Accepted Values) => [['name','description','price','quantity','tax','tax_rate','taxed_price','discount','discounted_price','shipping','subtotal','total']]
     * @param array $buyer (Accepted Values) => [id, first_name, last_name, email, phone]
     * @param string $invoice_id
     * @return array
     */

    public function payBySavedCard(string $providerUserID, string $defaultCardID, float $price, string $currency = '', array $items = [], array $buyer = [], string $invoice_id = ''): array
    {
        try {
            $payBySavedCard = $this->provider->payBySavedCard($providerUserID, $defaultCardID, $price, $currency, $items, $buyer, $invoice_id);
            return $this->formatOutput(true, $payBySavedCard);
        } catch (\Exception $e) {
            $this->provider->logError($e);
            return $this->formatOutput(false, [], '', $e);
        }
    }
}
