<?php namespace Visiosoft\PaymentModule\Status;

use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Visiosoft\PaymentModule\Status\Contract\StatusRepositoryInterface;

class StatusSeeder extends Seeder
{

    /**
     * Run the seeder.
     */
    public function run(StatusRepositoryInterface $statusRepository)
    {
        if (!$statusRepository->newQuery()->where('slug', 'unpaid')->orderBy('id', 'ASC')->first()) {
            $statusRepository->create([
                'en' => [
                    'name' => 'Unpaid'
                ],
                'tr' => [
                    'name' => "Ödeme Bekliyor"
                ],
                'slug' => 'unpaid'
            ]);
        }
        if (!$statusRepository->newQuery()->where('slug', 'paid')->orderBy('id', 'ASC')->first()) {
            $statusRepository->create([
                'en' => [
                    'name' => 'Paid'
                ],
                'tr' => [
                    'name' => "Ödendi"
                ],
                'slug' => 'Paid'
            ]);
        }
        if (!$statusRepository->newQuery()->where('slug', 'pending')->orderBy('id', 'ASC')->first()) {
            $statusRepository->create([
                'en' => [
                    'name' => 'Pending'
                ],
                'tr' => [
                    'name' => 'Ödeme isteği yapıldı'
                ],
                'slug' => 'pending'
            ]);
        }
        if (!$statusRepository->newQuery()->where('slug', 'failed')->orderBy('id', 'ASC')->first()) {
            $statusRepository->create([
                'en' => [
                    'name' => 'Failed'
                ],
                'tr' => [
                    'name' => 'Hatalı Ödeme'
                ],
                'slug' => 'failed'
            ]);
        }
        if (!$statusRepository->newQuery()->where('slug', 'free')->orderBy('id', 'ASC')->first()) {
            $statusRepository->create([
                'en' => [
                    'name' => 'Free'
                ],
                'tr' => [
                    'name' => 'Ücretsiz'
                ],
                'slug' => 'Free'
            ]);
        }
    }
}
