<?php namespace Visiosoft\PaymentModule\Payment\SettingsHandler;

use Anomaly\SelectFieldType\SelectFieldType;
use Anomaly\Streams\Platform\Addon\Extension\ExtensionCollection;

class CardSaveHandler
{
    public function handle(SelectFieldType $fieldType,ExtensionCollection $extensions)
    {

        $save_or_pay_provider = $extensions->search('visiosoft.module.payment::save_and_pay_provider.*')
            ->pluck('name', 'namespace')->all();

        $card_save_provider = $extensions->search('visiosoft.module.payment::card_save_provider.*')
            ->pluck('name', 'namespace')->all();


        $provider_values = array_merge($save_or_pay_provider, $card_save_provider);

        $fieldType->setOptions($provider_values);
    }
}
