<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;

class VisiosoftModulePaymentCreatePaymentMethodStream extends Migration
{

    /**
     * This migration creates the stream.
     * It should be deleted on rollback.
     *
     * @var bool
     */
    protected $delete = false;

    /**
     * The stream definition.
     *
     * @var array
     */
    protected $stream = [
        'slug' => 'payment_method',
        'title_column' => 'id',
        'translatable' => false,
        'versionable' => false,
        'trashable' => true,
        'searchable' => false,
        'sortable' => false,
    ];

    /**
     * The stream assignments.
     *
     * @var array
     */

    protected $fields = [
        'owner' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' => \Anomaly\UsersModule\User\UserModel::class
            ]
        ],
        'service' => 'anomaly.field_type.text',
        'service_payment_method_id' => 'anomaly.field_type.text',
        'customer' => 'anomaly.field_type.text',
        'card' => 'anomaly.field_type.textarea',
        'billing_details' => 'anomaly.field_type.textarea',
        'created' => 'anomaly.field_type.datetime',
        'metadata' => 'anomaly.field_type.textarea',
        'livemode' => 'anomaly.field_type.boolean',
        'type' => 'anomaly.field_type.text'
    ];

    protected $assignments = [
        'owner',
        'service',
        'service_payment_method_id',
        'customer',
        'card',
        'billing_details',
        'created',
        'livemode',
        'type',
        'metadata',
        'created'
    ];
}
