<?php namespace Visiosoft\PaymentModule\Category;

use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Visiosoft\PaymentModule\Category\Contract\CategoryRepositoryInterface;

class CategorySeeder extends Seeder
{

    /**
     * Run the seeder.
     */
    public function run(CategoryRepositoryInterface $categoryRepository)
    {

        $entries = [
            [
                'en' => [
                    'name' => 'Charging'
                ],
                'slug' => 'charging'
            ],
            [
                'en' => [
                    'name' => 'Parking'
                ],
                'slug' => 'parking'
            ],
            [
                'en' => [
                    'name' => 'Long term ticket'
                ],
                'slug' => 'long_term_ticket'
            ],
            [
                'en' => [
                    'name' => 'Park & Charge'
                ],
                'slug' => 'parking_and_charge'
            ],
        ];

        foreach ($entries as $entry) {
            if (!$categoryRepository->newQuery()->where('slug', $entry['slug'])->orderBy('id', 'ASC')->first()) {
                $categoryRepository->create($entry);
            }
        }
    }
}
