let formSelector = $('#submit-invoice-form').data('form');
let reference = $(formSelector).data('reference');
let method = $(reference + ' ' + formSelector).attr('method');
let formData = {
    customer_name: $(reference + ' .customer_name').attr('value'),
    customer_email: $(reference + ' .customer_email').attr('value')
};
$('#invoice-download').on('click', function () {
    let url = '/invoice/download/' + $(reference + ' .stripe_intent_id').attr('value');
    ajaxRequest('input', reference, method, url, successInvoiceDownload, error, formSelector, formData);
});

$('#invoice-form').on('click', function () {
    let url = '/invoice/email/' + $(reference + ' .stripe_intent_id').attr('value');
    ajaxRequest('form', reference, method, url, successInvoiceEmail, error, formSelector, formData);
});

function successInvoiceDownload(reference, response) {
    window.location.replace(response.response);
}

function successInvoiceEmail(reference, response) {
    if (response.success) {
        $(reference + ' .email-form-fields').text(response.message);
    }
}