<?php namespace Visiosoft\PaymentModule\PaymentMethod;

use Illuminate\Support\Facades\Auth;
use Visiosoft\PaymentModule\PaymentMethod\Contract\PaymentMethodRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

class PaymentMethodRepository extends EntryRepository implements PaymentMethodRepositoryInterface
{

    protected $model;

    public function __construct(PaymentMethodModel $model)
    {
        $this->model = $model;
    }

    public function addPaymentMethod(array $params)
    {
        if (!empty($params['billing_details'])) {
            $params['billing_details'] = (string)json_encode($params['billing_details']);
        }

        if (!empty($params['card'])) {
            $params['card'] = (string)json_encode($params['card']);
        }
        $params['metadata'] = null;
        if (!empty($params['metadata'])) {
            $params['metadata'] = (string)json_encode($params['metadata']);
        }
        $this->newQuery()->where('owner_id', Auth::id())->update(['default' => 0]);
        $params['default'] = 1;
        return $this->newQuery()->create($params);
    }
}
