<?php namespace Visiosoft\PaymentModule\Listener;

use Visiosoft\PaymentModule\Payment\Contract\PaymentRepositoryInterface;
use Visiosoft\PaypalWebhooksExtension\Events\OrderApproved;

class PaymentApprovedListener
{
    public function handle(OrderApproved $event) {
        if(!$paymentId =$event->values['resource']['purchase_units'][0]['payments']['captures'][0]['invoice_id']) {
            throw new \Exception(trans('visiosoft.module.payment::message.invoice_id_not_found'));
        }
        //todo log if paymentId not found *****************important**************
        $paymentRepository = app(PaymentRepositoryInterface::class);
        if (!$payment = $paymentRepository->find($paymentId)) {
            throw new \Exception(trans('visiosoft.module.payment::message.payment_not_found'));
        }
        $payment->update(['status_id' => 2]);
    }
}