<?php namespace Visiosoft\PaymentModule\Payment;

use Anomaly\UsersModule\User\UserModel;
use Visiosoft\ChargingModule\Transaction\TransactionModel;
use Visiosoft\ParkingModule\ParkingSession\ParkingSessionModel;
use Visiosoft\PaymentModule\Payment\Contract\PaymentInterface;
use Anomaly\Streams\Platform\Model\Payment\PaymentPaymentEntryModel;
use Visiosoft\PaymentModule\PaymentModule;
use Visiosoft\VehicleModule\Vehicle\VehicleModel;

class PaymentModel extends PaymentPaymentEntryModel implements PaymentInterface
{

    protected $appends = [
        'charging_transaction',
        'park_session',
        'vehicle',
        'payment_category',
        'payment_status',
        'user',
        'invoice_download',
        'name',
        'fees'
    ];

    public function getFeesAttribute()
    {
        return app(PaymentModule::class)->getFees($this->amount);
    }

    public function getInvoiceDownloadAttribute()
    {
        $file = $this->invoiceFile()->first();
        if ($file) {
            return config('app.url') . '/files/' . $file->path();
        }
        return null;
    }

    public function getUserAttribute()
    {
        return $this->user()->first();
    }

    public function getNameAttribute()
    {
        if ($session = $this->parkSession()->first()) {
            return $session->park()->first()->name;
        }
        if ($transaction = $this->transaction()->first()) {
            $station = $transaction->station()->first();
            if ($station && isset($station->title)){
                return $station->title;
            }else{
                return "";
            }
        }
    }

    public function getParkSessionAttribute()
    {
        return $this->parkSession()->first();
    }

    public function getChargingTransactionAttribute()
    {
        return $this->chargingTransaction()->first();
    }


    public function getPaymentCategoryAttribute()
    {
        return $this->category()->first();
    }

    public function chargingTransaction()
    {
        return $this->belongsTo(TransactionModel::class, 'transaction_id');
    }


    public function parkSession()
    {
        return $this->belongsTo(ParkingSessionModel::class, 'park_session_id');
    }

    public function getVehicleAttribute()
    {
        return $this->vehicle()->first();
    }

    public function vehicle()
    {
        return $this->belongsTo(VehicleModel::class, 'vehicle_id');
    }

    public function getPaymentStatusAttribute()
    {
        return $this->status()->first();
    }

    public function user() {
        return $this->belongsTo(UserModel::class)->withTrashed();
    }

    public function setPaymentMethod($type, $info)
    {
        return json_encode(['type' => $type, 'info' => $info]);
    }

    public function getPaymentMethod()
    {
        return json_decode($this->payment_method);
    }
}
