<?php

namespace Visiosoft\PaymentModule\Listener;

use Visiosoft\PaymentModule\Payment\Contract\PaymentRepositoryInterface;
use Visiosoft\PaypalWebhooksExtension\Events\PaymentStarted;

class PaymentStartedListener
{
    public function handle(PaymentStarted $event) {
        if(!$paymentId = $event['resource']['payments']['captures']['invoice_id']) {
            throw new \Exception(trans('visiosoft.module.payment::message.invoice_id_not_found'));
        }
        //todo log if paymentId not found *****************important**************
        $paymentRepository = app(PaymentRepositoryInterface::class);
        if (!$payment = $paymentRepository->find($paymentId)) {
            throw new \Exception(trans('visiosoft.module.payment::message.payment_not_found'));
        }
        $payment->update(['status_id' => 3]);
    }
}