<?php namespace Visiosoft\PaymentModule\Console\Command;

use Illuminate\Console\Command;
use Visiosoft\PaymentModule\Payment\Contract\PaymentRepositoryInterface;

class PaidInvoiceGenerateCommand extends Command
{
    protected $signature = 'paid_invoice:generate';
    protected $description = 'auto charge over limit';

    public function __construct()
    {
        parent::__construct();
    }

    public function handle()
    {
        $paymentRepository = app(PaymentRepositoryInterface::class);
        $paymentIds = $paymentRepository->newQuery()
            ->whereNull('deleted_at')
            ->whereNull('invoice_id')
            ->where('status_id', 2)
            ->pluck('id');
        foreach ($paymentIds as $id) {
            $paymentRepository->createPaymentInvoice($id);
        }
    }
}
